/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import com.google.common.collect.Lists;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public interface IShape
extends Iterable<Coord> {
    default public IShape fill(WorldEditor editor, BlockBrush block) {
        return this.fill(editor, block, true, true);
    }

    default public IShape fill(WorldEditor editor, BlockBrush block, boolean fillAir, boolean replaceSolid) {
        for (Coord coord : this) {
            block.stroke(editor, coord, fillAir, replaceSolid);
        }
        return this;
    }

    public List<Coord> get();

    public Set<Coord> getAnchors();

    default public IShape translate(Direction direction, int amount) {
        this.getAnchors().forEach(coord -> coord.translate(direction, amount));
        return this;
    }

    default public IShape translate(Direction direction) {
        this.translate(direction, 1);
        return this;
    }

    default public IShape up(int amount) {
        return this.translate(Direction.UP, amount);
    }

    default public IShape up() {
        return this.up(1);
    }

    default public IShape down(int amount) {
        return this.translate(Direction.DOWN, amount);
    }

    default public IShape down() {
        return this.down(1);
    }

    default public IShape north(int amount) {
        return this.translate(Direction.NORTH, amount);
    }

    default public IShape north() {
        return this.north(1);
    }

    default public IShape east(int amount) {
        return this.translate(Direction.EAST, amount);
    }

    default public IShape east() {
        return this.east(1);
    }

    default public IShape south(int amount) {
        return this.translate(Direction.SOUTH, amount);
    }

    default public IShape south() {
        return this.south(1);
    }

    default public IShape west(int amount) {
        return this.translate(Direction.WEST, amount);
    }

    default public IShape west() {
        return this.west(1);
    }

    default public List<Coord> asList() {
        ArrayList coords = Lists.newArrayList();
        for (Coord c : this) {
            coords.add(c);
        }
        return coords;
    }
}

